/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.udeployversion;

import com.urbancode.airplugins.AirPluginTool;
import com.urbancode.ud.client.VersionClient;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import java.util.UUID;
import org.codehaus.jettison.json.JSONObject;

public class GetVersionType {
    private final AirPluginTool apTool;

    GetVersionType(String[] args) {
        this.apTool = new AirPluginTool(args[0], args[1]);
    }

    public static void main(String[] args) {
        try {
            new GetVersionType(args).run();
        }
        catch (Exception e) {
            System.out.printf("Error: %s%n", e.getMessage());
            System.exit(1);
        }
        System.exit(0);
    }

    public void run() throws Exception {
        VersionClient udRestClient = this.getVersionClient();
        Properties props = this.apTool.getStepProperties();
        String versionName = props.getProperty("versionName").trim();
        String componentName = props.getProperty("componentName").trim();
        if (versionName.isEmpty()) {
            throw new IllegalArgumentException("Version name is required.");
        }
        if (componentName.isEmpty()) {
            throw new IllegalArgumentException("Component name is required.");
        }
        System.out.printf("Getting type for Version %s of Component %s.%n", versionName, componentName);
        UUID versionId = udRestClient.getVersionId(componentName, versionName);
        JSONObject versionJson = udRestClient.getVersion(versionId.toString());
        String versionType = versionJson.getString("type");
        this.apTool.setOutputProperty("versionType", versionType);
        this.apTool.storeOutputProperties();
        System.out.println("Version type added to output properties.");
    }

    private VersionClient getVersionClient() throws URISyntaxException {
        String udUrl = System.getenv("AH_WEB_URL");
        String udUser = this.apTool.getAuthTokenUsername();
        String udPass = this.apTool.getAuthToken();
        return new VersionClient(new URI(udUrl), udUser, udPass);
    }
}

