/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* UrbanCode Build
* UrbanCode Release
* AnthillPro
* (c) Copyright IBM Corporation 2011, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/
/**
 * Created by david on 12/10/14.
 */
import com.urbancode.air.AirPluginTool
import com.urbancode.ud.client.VersionClient


def apTool = new AirPluginTool(this.args[0], this.args[1]);

def props = apTool.getStepProperties();

def version = props["version"]
def component = props["component"] ? props["component"] : null
def udUser = apTool.getAuthTokenUsername()
def udPass = apTool.getAuthToken()
def webUrl = System.getenv("AH_WEB_URL")

def udRestClient = new VersionClient(new URI(webUrl), udUser, udPass)

println "Getting version properties for version id $version."
Map<String, String> versionProps = udRestClient.getVersionProperties(version, component);
for (String key : versionProps.keySet()) {
    String value = versionProps.get(key)
    println "$key: $value"
    apTool.setOutputProperty(key, value)
}
apTool.setOutputProperties()
println "Version properties retrieved."