/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ud.client;

import com.urbancode.ud.client.ComponentClient;
import com.urbancode.ud.client.UDRestClient;
import java.io.IOException;
import java.net.URI;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class ResourceClient
extends UDRestClient {
    public ResourceClient(URI url, String clientUser, String clientPassword) {
        super(url, clientUser, clientPassword);
    }

    public ResourceClient(URI url, String clientUser, String clientPassword, boolean trustAllCerts) {
        super(url, clientUser, clientPassword, trustAllCerts);
    }

    public ResourceClient(URI url, DefaultHttpClient client) {
        super(url, client);
    }

    public void addResourceToTeam(String resource, String team, String type) throws IOException {
        String uri = this.url + "/cli/resource/teams?team=" + this.encodePath(team) + "&type=" + this.encodePath(type) + "&resource=" + this.encodePath(resource);
        HttpPut method = new HttpPut(uri);
        this.invokeMethod((HttpRequestBase)method);
    }

    public String addTagToResource(String resourceName, String tagName) throws IOException {
        String result = null;
        String uri = this.url + "/cli/resource/tag?resource=" + this.encodePath(resourceName) + "&tag=" + this.encodePath(tagName);
        HttpPut method = new HttpPut(uri);
        CloseableHttpResponse response = this.invokeMethod((HttpRequestBase)method);
        result = this.getBody(response);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRoleOnResource(String resource, String role, Map<String, String> properties) throws IOException, JSONException {
        String uri = this.url + "/rest/resource/resource/" + this.encodePath(resource) + "/role/" + this.encodePath(role);
        JSONObject propertiesObject = new JSONObject();
        for (Map.Entry<String, String> ent : properties.entrySet()) {
            propertiesObject.put(ent.getKey(), (Object)ent.getValue());
        }
        HttpPost method = new HttpPost(uri);
        try {
            method.setEntity((HttpEntity)this.getStringEntity(propertiesObject));
            this.invokeMethod((HttpRequestBase)method);
        }
        finally {
            this.releaseConnection((HttpRequestBase)method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createResourceInventoryEntry(String deploymentRequest, String resourceId, String componentId, String versionId, String status) throws IOException, JSONException {
        String uri = this.url + "/rest/inventory/entries";
        JSONObject entry = new JSONObject();
        entry.put("resourceId", (Object)resourceId);
        entry.put("componentId", (Object)componentId);
        entry.put("versionId", (Object)versionId);
        entry.put("status", (Object)status);
        JSONArray entries = new JSONArray();
        entries.put((Object)entry);
        JSONObject requestBody = new JSONObject();
        requestBody.put("deploymentRequest", (Object)deploymentRequest);
        requestBody.put("entries", (Object)entries);
        HttpPut method = new HttpPut(uri);
        try {
            method.setEntity((HttpEntity)this.getStringEntity(requestBody));
            this.invokeMethod((HttpRequestBase)method);
        }
        finally {
            this.releaseConnection((HttpRequestBase)method);
        }
    }

    public String createResource(String name, String agentName, String agentPoolName, String parentName, String role) throws IOException, JSONException {
        return this.createResource(name, agentName, agentPoolName, parentName, role, null);
    }

    public String createResource(String name, String agentName, String agentPoolName, String parentName, String role, String componentTag) throws IOException, JSONException {
        String result = null;
        JSONObject jsonToSend = new JSONObject();
        jsonToSend.put("name", (Object)name);
        if (!StringUtils.isEmpty((CharSequence)parentName)) {
            jsonToSend.put("parent", (Object)parentName);
        }
        if (!StringUtils.isEmpty((CharSequence)role)) {
            JSONObject existingComponent = null;
            ComponentClient componentClient = new ComponentClient(this.url, this.client);
            try {
                existingComponent = componentClient.getComponent(role);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (existingComponent != null) {
                role = existingComponent.getJSONObject("resourceRole").getString("id");
            }
            jsonToSend.put("role", (Object)role);
        }
        if (!StringUtils.isEmpty((CharSequence)componentTag)) {
            jsonToSend.put("componentTag", (Object)componentTag);
        }
        if (!StringUtils.isEmpty((CharSequence)agentName)) {
            jsonToSend.put("agent", (Object)agentName);
        } else if (!StringUtils.isEmpty((CharSequence)agentPoolName)) {
            jsonToSend.put("agentPool", (Object)agentPoolName);
        }
        String uri = this.url + "/cli/resource/create";
        HttpPut method = new HttpPut(uri);
        method.setEntity((HttpEntity)this.getStringEntity(jsonToSend));
        CloseableHttpResponse response = this.invokeMethod((HttpRequestBase)method);
        result = this.getBody(response);
        return result;
    }

    public String batchSaveResource(String rootResource, String jsonInput) throws IOException, JSONException {
        String result = null;
        String uri = this.url + "/rest/resource/resource/" + this.encodePath(rootResource) + "/batch";
        HttpPut method = new HttpPut(uri);
        method.setEntity((HttpEntity)this.getStringEntity(jsonInput));
        CloseableHttpResponse response = this.invokeMethod((HttpRequestBase)method);
        result = this.getBody(response);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID createResourceRole(String roleName, String description) throws IOException, JSONException {
        UUID result;
        String uri = this.url + "/rest/resource/resourceRole";
        JSONObject resourceObject = new JSONObject();
        resourceObject.put("name", (Object)roleName);
        resourceObject.put("description", (Object)description);
        HttpPost method = new HttpPost(uri);
        try {
            method.setEntity((HttpEntity)this.getStringEntity(resourceObject));
            CloseableHttpResponse response = this.invokeMethod((HttpRequestBase)method);
            String body = this.getBody(response);
            result = UUID.fromString(new JSONObject(body).getString("id"));
        }
        finally {
            this.releaseConnection((HttpRequestBase)method);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID createSubResource(UUID parentId, String resourceName, String description) throws IOException, JSONException {
        UUID result;
        String uri = this.url + "/rest/resource/resource";
        JSONObject resourceObject = new JSONObject();
        resourceObject.put("name", (Object)resourceName);
        resourceObject.put("parentId", (Object)parentId);
        resourceObject.put("description", (Object)description);
        HttpPut method = new HttpPut(uri);
        try {
            method.setEntity((HttpEntity)this.getStringEntity(resourceObject));
            CloseableHttpResponse response = this.invokeMethod((HttpRequestBase)method);
            String body = this.getBody(response);
            result = UUID.fromString(new JSONObject(body).getString("id"));
        }
        finally {
            this.releaseConnection((HttpRequestBase)method);
        }
        return result;
    }

    public void deleteResource(String name) throws IOException {
        String uri = this.url + "/cli/resource/deleteResource?resource=" + this.encodePath(name);
        HttpDelete method = new HttpDelete(uri);
        CloseableHttpResponse response = this.invokeMethod((HttpRequestBase)method);
        this.discardBody(response);
    }

    public void deleteResourceInventoryForComponent(String resourceName, String componentName, String version, String inventoryStatus) throws IOException {
        String uri = this.url + "/rest/inventory/resourceInventoryForComponent/?resource=" + this.encodePath(resourceName) + "&component=" + this.encodePath(componentName) + "&version=" + this.encodePath(version) + "&status=" + this.encodePath(inventoryStatus);
        HttpDelete method = new HttpDelete(uri);
        CloseableHttpResponse response = this.invokeMethod((HttpRequestBase)method);
        this.discardBody(response);
    }

    public JSONObject getLatestVersionByResourceAndComponent(String resourceId, String componentId) throws Exception {
        JSONObject result = new JSONObject();
        String uri = this.url + "/rest/inventory/versionByResourceAndComponent/" + this.encodePath(resourceId) + "/" + this.encodePath(componentId);
        HttpGet method = new HttpGet(uri);
        CloseableHttpResponse response = this.invokeMethod((HttpRequestBase)method);
        String body = this.getBody(response);
        result = new JSONObject(body);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getResourceByPath(String path) throws IOException, JSONException {
        JSONObject result = null;
        String uri = this.url + "/rest/resource/resource/" + this.encodePath(path);
        HttpGet method = new HttpGet(uri);
        try {
            CloseableHttpResponse response = this.invokeMethod((HttpRequestBase)method);
            String body = this.getBody(response);
            result = new JSONObject(body);
        }
        finally {
            this.releaseConnection((HttpRequestBase)method);
        }
        return result;
    }

    public JSONObject getResourceById(String id) throws IOException, JSONException {
        JSONObject result = null;
        String uri = this.url + "/rest/resource/resource/" + this.encodePath(id);
        HttpGet method = new HttpGet(uri);
        CloseableHttpResponse response = this.invokeMethod((HttpRequestBase)method);
        String body = this.getBody(response);
        result = new JSONObject(body);
        return result;
    }

    public JSONArray getResourceChildren(String id) throws IOException, JSONException {
        JSONArray result = null;
        String uri = this.url + "/cli/resource/?parent=" + this.encodePath(id);
        HttpGet method = new HttpGet(uri);
        CloseableHttpResponse response = this.invokeMethod((HttpRequestBase)method);
        String body = this.getBody(response);
        result = new JSONArray(body);
        return result;
    }

    public String getResourceProperty(String resourceName, String name) throws IOException {
        if ("".equals(resourceName) || "".equals(name)) {
            throw new IOException("a required argument was not supplied");
        }
        String uri = this.url + "/cli/resource/getProperty?resource=" + this.encodePath(resourceName) + "&name=" + this.encodePath(name);
        HttpGet method = new HttpGet(uri);
        CloseableHttpResponse response = this.invokeMethod((HttpRequestBase)method);
        String result = this.getBody(response);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getResourceRoleByName(String name) throws IOException, JSONException {
        JSONObject result = null;
        String uri = this.url + "/rest/resource/resourceRole/" + this.encodePath(name);
        HttpGet method = new HttpGet(uri);
        try {
            CloseableHttpResponse response = this.invokeMethod((HttpRequestBase)method);
            String body = this.getBody(response);
            result = new JSONObject(body);
        }
        finally {
            this.releaseConnection((HttpRequestBase)method);
        }
        return result;
    }

    public JSONArray getResourceRoleProperties(String roleName, String resourceName) throws IOException, JSONException {
        if ("".equals(roleName) || "".equals(resourceName)) {
            throw new IOException("a required argument was not supplied");
        }
        String uri = this.url + "/rest/resource/resource/" + this.encodePath(resourceName) + "/propertiesForRole/" + this.encodePath(roleName);
        HttpGet method = new HttpGet(uri);
        CloseableHttpResponse response = this.invokeMethod((HttpRequestBase)method);
        JSONArray result = new JSONArray(this.getBody(response));
        return result;
    }

    public String getResourceRolePropertyForResource(String roleName, String resourceName, String name) throws IOException, JSONException {
        JSONArray currentProps = this.getResourceRoleProperties(roleName, resourceName);
        JSONObject propsJSON = this.convertPropArrayToKeyValuePairs(currentProps);
        return propsJSON.getString(name);
    }

    public JSONArray getResourceRoles(String resource) throws IOException, JSONException {
        JSONArray result = null;
        String uri = this.url + "/rest/resource/resource/" + this.encodePath(resource) + "/roles";
        HttpGet method = new HttpGet(uri);
        CloseableHttpResponse response = this.invokeMethod((HttpRequestBase)method);
        String body = this.getBody(response);
        result = new JSONArray(body);
        return result;
    }

    public List<String> getResourceRolesAsStrings(String resource) throws IOException, JSONException {
        ArrayList<String> result = new ArrayList<String>();
        String uri = this.url + "/cli/resource/getRolesForResource?resource=" + this.encodePath(resource);
        HttpGet method = new HttpGet(uri);
        CloseableHttpResponse response = this.invokeMethod((HttpRequestBase)method);
        String body = this.getBody(response);
        JSONArray resultAsJSON = new JSONArray(body);
        for (int i = 0; i < resultAsJSON.length(); ++i) {
            String roleName = (String)((JSONObject)resultAsJSON.get(i)).get("name");
            result.add(roleName);
        }
        return result;
    }

    public JSONArray getResourceTree() throws IOException, JSONException {
        JSONArray result = null;
        String uri = this.url + "/rest/resource/resource/tree";
        HttpGet method = new HttpGet(uri);
        CloseableHttpResponse response = this.invokeMethod((HttpRequestBase)method);
        String body = this.getBody(response);
        result = new JSONArray(body);
        return result;
    }

    public void inactivateResource(String name) throws IOException {
        String uri = this.url + "/rest/resource/resource/" + this.encodePath(name) + "/inactivate";
        HttpPut method = new HttpPut(uri);
        CloseableHttpResponse response = this.invokeMethod((HttpRequestBase)method);
        this.discardBody(response);
    }

    public void removeRoleFromResource(String resource, String role) throws IOException {
        String uri = this.url + "/cli/resource/removeRoleFromResource?resource=" + this.encodePath(resource) + "&role=" + this.encodePath(role);
        HttpDelete method = new HttpDelete(uri);
        this.invokeMethod((HttpRequestBase)method);
    }

    public String removeTagFromResource(String resourceName, String tagName) throws IOException {
        String result = null;
        String uri = this.url + "/cli/resource/tag?resource=" + this.encodePath(resourceName) + "&tag=" + this.encodePath(tagName);
        HttpDelete method = new HttpDelete(uri);
        CloseableHttpResponse response = this.invokeMethod((HttpRequestBase)method);
        result = this.getBody(response);
        return result;
    }

    public String setResourceProperty(String resourcePath, String name, String value, boolean isSecure) throws IOException {
        if ("".equals(resourcePath) || "".equals(name)) {
            throw new IOException("a required argument was not supplied");
        }
        String uri = this.url + "/cli/resource/setProperty";
        HttpPut method = null;
        if (this.isSecurePropTransfer()) {
            JSONObject entity = new JSONObject();
            try {
                entity.put("resource", (Object)resourcePath).put("name", (Object)name).put("value", (Object)value).put("isSecure", isSecure);
            }
            catch (JSONException e) {
                throw new IOException(e.getMessage(), e);
            }
            method = new HttpPut(uri);
            method.setEntity((HttpEntity)new StringEntity(entity.toString()));
        } else {
            uri = uri + "?resource=" + this.encodePath(resourcePath) + "&name=" + this.encodePath(name) + "&value=" + this.encodePath(value) + "&isSecure=" + this.encodePath(String.valueOf(isSecure));
            method = new HttpPut(uri);
        }
        this.invokeMethod((HttpRequestBase)method);
        String result = isSecure ? name + "=****" : name + "=" + value;
        return result;
    }

    public String setResourceRoleProperty(String roleName, String resourceName, String name, String value) throws IOException, JSONException {
        if ("".equals(roleName) || "".equals(resourceName) || "".equals("name")) {
            throw new IOException("a required argument was not supplied");
        }
        String uri = this.url + "/rest/resource/resource/" + this.encodePath(resourceName) + "/savePropertiesForRole/" + this.encodePath(roleName);
        JSONArray currentProps = this.getResourceRoleProperties(roleName, resourceName);
        JSONObject jsonToSend = this.convertPropArrayToKeyValuePairs(currentProps);
        jsonToSend.put(name, (Object)value);
        HttpPut method = new HttpPut(uri);
        method.setEntity((HttpEntity)this.getStringEntity(jsonToSend));
        this.invokeMethod((HttpRequestBase)method);
        String result = name + "=" + value;
        return result;
    }

    public void setResourceRoleProperties(String roleName, String resourceName, JSONObject values) throws IOException, JSONException {
        if (StringUtils.isEmpty((CharSequence)roleName) || StringUtils.isEmpty((CharSequence)resourceName)) {
            throw new IOException("a required argument was not supplied");
        }
        String uri = this.url + "/rest/resource/resource/" + this.encodePath(resourceName) + "/savePropertiesForRole/" + this.encodePath(roleName);
        JSONArray currentProps = this.getResourceRoleProperties(roleName, resourceName);
        JSONObject jsonToSend = this.convertPropArrayToKeyValuePairs(currentProps);
        Iterator keys = values.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            jsonToSend.put(key, (Object)values.getString(key));
        }
        HttpPut method = new HttpPut(uri);
        method.setEntity((HttpEntity)this.getStringEntity(jsonToSend));
        CloseableHttpResponse response = this.invokeMethod((HttpRequestBase)method);
        int status = response.getStatusLine().getStatusCode();
        if (status != 200) {
            throw new IOException(String.format("%d %s\n%s", response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), this.getBody(response)));
        }
    }

    public void waitForResourceCreation(String name) throws IOException, InterruptedException, RemoteException {
        String uri = this.url + "/cli/resource/info?resource=" + this.encodePath(name);
        HttpGet method = new HttpGet(uri);
        CloseableHttpResponse response = this.invokeMethod((HttpRequestBase)method);
        int status = response.getStatusLine().getStatusCode();
        long pollInterval = 1000L;
        long timeoutInterval = 600000L;
        long start = System.currentTimeMillis();
        while (status == 404) {
            if (System.currentTimeMillis() - start > timeoutInterval) {
                throw new RemoteException("Timeout waiting for Resource Creation");
            }
            try {
                this.discardBody(response);
                Thread.sleep(pollInterval);
                response = this.invokeMethod((HttpRequestBase)method);
            }
            catch (IOException iOException) {}
        }
        if (status != 200) {
            throw new IOException(String.format("%d %s\n%s", response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), this.getBody(response)));
        }
    }

    public JSONArray compareResourceTrees(String leftResourceId, String rightResourceId) throws IOException, JSONException {
        String uri = this.url + "/rest/resource/resource/compare/" + this.encodePath(leftResourceId) + "/" + this.encodePath(rightResourceId);
        HttpGet method = new HttpGet(uri);
        CloseableHttpResponse response = this.invokeMethod((HttpRequestBase)method);
        String body = this.getBody(response);
        JSONArray result = new JSONArray(body);
        return result;
    }

    public void syncResourceTrees(JSONArray changes) throws IOException {
        HttpPost method = new HttpPost(this.url + "/rest/resource/resource/applyCompareChanges");
        method.setEntity((HttpEntity)this.getStringEntity(changes));
        this.invokeMethod((HttpRequestBase)method);
    }

    public void applyTemplate(String resourceParam, String resourceTemplateId, Properties properties) throws JSONException, IOException {
        JSONObject json = new JSONObject();
        json.put("resourceTemplateId", (Object)resourceTemplateId);
        json.put("targetResourceId", (Object)resourceParam);
        for (Object key : properties.keySet()) {
            String propertyKey = "p_" + (String)key;
            json.put(propertyKey, properties.get(key));
        }
        HttpPut method = new HttpPut(this.url + "/rest/resource/resource/applyTemplate");
        method.setEntity((HttpEntity)this.getStringEntity(json));
        this.invokeMethod((HttpRequestBase)method);
    }

    public JSONArray intersectArtifactsInTargetResource(String resourceId, String componentId, String versionId) throws IOException, JSONException {
        if ("".equals(resourceId) || "".equals(componentId) || "".equals(versionId)) {
            throw new IOException("a required argument was not supplied");
        }
        String uri = this.url + "/rest/inventory/" + this.encodePath(resourceId) + "/" + this.encodePath(componentId) + "/zosArtifactsIntersection/" + this.encodePath(versionId);
        HttpGet method = new HttpGet(uri);
        CloseableHttpResponse response = this.invokeMethod((HttpRequestBase)method);
        String body = this.getBody(response);
        JSONArray versionsJson = new JSONArray(body);
        return versionsJson;
    }
}

