/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.iterator.files;

import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.iterator.AbstractSentinelIterator;
import java.io.File;
import java.util.Iterator;
import java.util.regex.Pattern;

final class EachDirectoryPIterator
extends AbstractSentinelIterator<File> {
    private final Iterator<File> iterator;
    private final Pattern directoryPattern;

    EachDirectoryPIterator(File directory, Pattern filePattern) {
        this.iterator = IO.listFiles(directory).iterator();
        this.directoryPattern = filePattern;
    }

    @Override
    protected File nextItem() {
        File result = null;
        while (this.iterator.hasNext()) {
            File file = this.iterator.next();
            String name = file.getName();
            if (!file.isDirectory() || !this.directoryPattern.matcher(name).matches()) continue;
            result = file;
            break;
        }
        return result;
    }
}

