/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.web.controller;

import com.urbancode.commons.profiler.Profiler;
import com.urbancode.commons.web.controller.ControllerServlet;
import com.urbancode.commons.web.controller.DynamicResponse;
import com.urbancode.commons.web.controller.URLResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class URLTextResponse
extends URLResponse
implements DynamicResponse {
    private static final Logger log = Logger.getLogger(ControllerServlet.class);
    private final String destination;
    private final List<URLResponse.Param> paramList = new ArrayList<URLResponse.Param>();
    private final List<URLResponse.Attr> sessionAttrList = new ArrayList<URLResponse.Attr>();
    private String anchor = null;

    public URLTextResponse(String destination) {
        int anchorIdx = destination.indexOf(35);
        if (anchorIdx == -1) {
            this.destination = destination;
            this.anchor = null;
        } else {
            this.destination = destination.substring(0, anchorIdx);
            this.anchor = destination.substring(anchorIdx + 1);
        }
    }

    public void respond(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String activityName = Profiler.getInstance().startActivity("RedirectResponse.respond (" + this.destination + ")");
        this.addAttributes(request);
        String destination = this.computeUrl(request, response);
        response.setContentType("text/plain");
        String encoding = response.getCharacterEncoding();
        byte[] data = destination.getBytes(encoding);
        response.setContentLength(data.length);
        ServletOutputStream out = response.getOutputStream();
        out.write(data);
        out.flush();
        Profiler.getInstance().stopActivity(activityName);
    }

    public final String getDestination() {
        return this.destination;
    }

    public final URLTextResponse setAnchor(String anchor) {
        this.anchor = anchor;
        return this;
    }

    public final URLTextResponse addParam(String name, Object value) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (value != null) {
            URLResponse.Param param = new URLResponse.Param(name, String.valueOf(value));
            this.paramList.add(param);
        }
        return this;
    }

    public final URLTextResponse addSessionAttr(String name, Object value) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        URLResponse.Attr attr = new URLResponse.Attr(name, value);
        this.sessionAttrList.add(attr);
        return this;
    }

    protected void addAttributes(HttpServletRequest request) {
        HttpSession session = request.getSession();
        for (URLResponse.Attr attr : this.sessionAttrList) {
            session.setAttribute(attr.getName(), attr.getValue());
        }
    }

    protected String computeUrl(HttpServletRequest request, HttpServletResponse response) {
        StringBuilder result = new StringBuilder();
        result.append(this.computePath(request, response));
        result.append(this.computeQuery(request, response));
        return result.toString();
    }

    protected String computePath(HttpServletRequest request, HttpServletResponse response) {
        return this.destination.startsWith("/") ? request.getContextPath() + this.destination : this.destination;
    }

    protected String computeQuery(HttpServletRequest request, HttpServletResponse response) {
        StringBuilder result = new StringBuilder();
        try {
            boolean startQuerry = !this.destination.contains("?");
            for (URLResponse.Param p : this.paramList) {
                if (startQuerry) {
                    result.append('?');
                    startQuerry = false;
                } else {
                    result.append('&');
                }
                result.append(URLEncoder.encode(p.getName(), "UTF-8"));
                result.append('=');
                result.append(URLEncoder.encode(p.getValue(), "UTF-8"));
            }
            if (this.anchor != null) {
                if (!this.paramList.isEmpty()) {
                    result.append("&t=0");
                }
                result.append("#");
                result.append(this.anchor);
            }
        }
        catch (UnsupportedEncodingException e) {
            log.warn("The error should never occur: " + e.toString(), e);
        }
        return result.toString();
    }
}

